function crep = chooserep(creps, class, rep)
%crep = chooserep(creps, class, rep)
%
%Chooses one of the coefficient representations for a filter.
%Inputs:
%  creps - structure generated by gencoeffreps
%  class - the class to choose from: 'bin' or 'msd'
%  rep - ID of the representation if the class has multiple
%        representations. Needed for 'msd'.
%Outputs:
%  crep - structure describing the chosen representation

%Copyright (C) 2008 Anton Blad, Oscar Gustafsson.
%This file is licensed under a modified version of GPL v2, see the file
%LICENSE for details.

if class == 'bin'
	hcoeffs = [];
	id = 0;
	for n = 1:length(creps.bin)
		hcoeffs = [hcoeffs; creps.bin{n}];
	end
elseif class == 'msd'
	hcoeffs = [];
	id = rep;
	for n = 1:length(creps.msd)
		terms = creps.msd{n};
		r = mod(rep, size(terms, 1));
		term = terms(r+1, :);
		rep = (rep-r)/size(terms, 1);

		hcoeffs = [hcoeffs;term];
	end
else
	error 'chooserep: Illegal class'
end

crep.h = creps.h;
crep.wc = creps.wc;
crep.class = class;
crep.id = id;
crep.coeffs = hcoeffs;

